<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, shrink-to-fit=no">
	<title>Admin - Deportivo Morelos</title>

	<!-- plugins css -->
	<link rel="stylesheet" href="<?php echo e(asset('themes/adminmorelos/bower_components/bootstrap/dist/css/bootstrap.css')); ?>" />
	<link rel="stylesheet" href="<?php echo e(asset('themes/adminmorelos/bower_components/PACE/themes/blue/pace-theme-minimal.css')); ?>" />
	<link rel="stylesheet" href="<?php echo e(asset('themes/adminmorelos/bower_components/perfect-scrollbar/css/perfect-scrollbar.min.css')); ?>" />

	<!--datatable-->
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('themes/adminmorelos/dataTables/datatables.min.css')); ?>">

	<!-- page plugins css -->
	<link rel="stylesheet" href="<?php echo e(asset('themes/adminmorelos/bower_components/bower-jvectormap/jquery-jvectormap-1.2.2.css')); ?>" />
	<link rel="stylesheet" href="<?php echo e(asset('themes/adminmorelos/bower_components/nvd3/build/nv.d3.min.css')); ?>" />
	<link rel="stylesheet" href="<?php echo e(asset('themes/adminmorelos/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker3.css')); ?>" />

	<!-- core css -->
	<link href="<?php echo e(asset('themes/adminmorelos/dist/assets/css/ei-icon.css?v=1.2')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('themes/adminmorelos/dist/assets/css/themify-icons.css?v=1.2')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('themes/adminmorelos/dist/assets/css/font-awesome.min.css?v=1.2')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('themes/adminmorelos/dist/assets/css/animate.min.css?v=1.2')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('themes/adminmorelos/dist/assets/css/app.css?v=1.2')); ?>" rel="stylesheet">
	<link rel="stylesheet" href="<?php echo e(asset('themes/adminmorelos/bower_components/summernote/dist/summernote.css?v=1.2')); ?>" />
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('themes/adminmorelos/dist/assets/css/plugins/sweetalert/sweetalert.css')); ?>" defer>
</head>

<body>
	<div class="app">
		<div class="layout">
			<!-- Side Nav START -->
			<div class="side-nav">
				<div class="side-nav-inner">
					<div class="side-nav-logo">
						<a href="<?php echo e(url('/admin-morelos')); ?>">
							<div class="logo logo-dark">
								<img class="img-responsive inline-block" src="<?php echo e(asset('themes/adminmorelos/dist/assets/images/logoa.png')); ?>" alt="" style="height: 50px; padding-top: 10px; padding-left: 10px">
							</div>
						</a>
						<div class="mobile-toggle side-nav-toggle">
							<a href="#">
								<i class="ti-arrow-circle-left"></i>
							</a>
						</div>
					</div>
					<ul class="side-nav-menu scrollable">
						<li class="nav-item active">
							<a class="mrg-top-30" href="<?php echo e(url('/admin-morelos')); ?>">
								<span class="icon-holder">
										<i class="ti-home"></i>
									</span>
								<span class="title">Inicio</span>
							</a>
						</li>
						<?php if(Auth::user()->rol!="Delegado"): ?>
							<li>
								<a href="<?php echo e(url('admin-morelos/usuarios')); ?>">
									<span class="icon-holder">
										<i class="ti-user"></i>
									</span>
									<span class="title">Usuarios</span>
								</a>
							</li>
							<li>
								<a href="<?php echo e(url('admin-morelos/noticias')); ?>">
									<span class="icon-holder">
										<i class="ti-align-justify"></i>
									</span>
									<span class="title">Noticias</span>
								</a>
							</li>
							<li>
								<a href="<?php echo e(url('admin-morelos/equipos')); ?>">
									<span class="icon-holder">
										<i class="ti-star"></i>
									</span>
									<span class="title">Equipos</span>
								</a>
							</li>
							<li>
								<a href="<?php echo e(url('admin-morelos/equipos/imprimirCredencial')); ?>">
									<span class="icon-holder">
										<i class="ti-printer"></i>
									</span>
									<span class="title">Credenciales</span>
								</a>
							</li>
							<li>
								<a href="<?php echo e(url('admin-morelos/equipos/multas')); ?>">
									<span class="icon-holder">
										<i class="ti-tag"></i>
									</span>
									<span class="title">Multas</span>
								</a>
							</li>
						<?php elseif(Auth::user()->rol=="Delegado"): ?>
							<li>
								<a href="<?php echo e(url('admin-morelos/jugadores')); ?>">
									<span class="icon-holder">
										<i class="ti-game"></i>
									</span>
									<span class="title">Jugadores</span>
								</a>
							</li>
						<?php endif; ?>
					</ul>
				</div>
			</div>
			<!-- Side Nav END -->

			<!-- Page Container START -->
			<div class="page-container">
				<!-- Header START -->
				<div class="header navbar">
					<div class="header-container">
						<ul class="nav-left">
							<li>
								<a class="side-nav-toggle" href="javascript:void(0);">
									<i class="ti-view-grid"></i>
								</a>
							</li>
						</ul>
						<ul class="nav-right">
							<li class="user-profile dropdown">
								<a href="#" class="dropdown-toggle" data-toggle="dropdown">
									<div class="user-info">
										<span class="name pdd-right-5"><?php echo e(Auth::user()->nombre); ?></span>
										<i class="ti-angle-down font-size-10"></i>
									</div>
								</a>
								<ul class="dropdown-menu">
									<li>
										<a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
									   onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
											<i class="ti-power-off pdd-right-10"></i> Salir
										</a>

										<form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
											<?php echo e(csrf_field()); ?>

										</form>
									</li>
								</ul>
							</li>
						</ul>
					</div>
				</div>
				<!-- Header END -->

				<!-- Content Wrapper START -->
				<div class="main-content">
					<div class="container-fluid">
						<?php echo $__env->yieldContent('content'); ?>
					</div>
				</div>
				<!-- Content Wrapper END -->

				<!-- Footer START -->
				<footer class="content-footer">
					<div class="footer">
						<div class="copyright">
							<span>Copyright © 2018. Todos los derechos reservados.</span>
						</div>
					</div>
				</footer>
				<!-- Footer END -->

			</div>
			<!-- Page Container END -->
		</div>
	</div>

	<script src="<?php echo e(asset('themes/adminmorelos/dist/assets/js/vendor.js')); ?>"></script>

	<!-- page plugins js -->
	<script src="<?php echo e(asset('themes/adminmorelos/bower_components/bower-jvectormap/jquery-jvectormap-1.2.2.min.js')); ?>"></script>
	<script src="<?php echo e(asset('themes/adminmorelos/dist/assets/js/maps/jquery-jvectormap-us-aea.js')); ?>"></script>
	<script src="<?php echo e(asset('themes/adminmorelos/bower_components/d3/d3.min.js')); ?>"></script>
	<script src="<?php echo e(asset('themes/adminmorelos/bower_components/nvd3/build/nv.d3.min.js')); ?>"></script>
	<script src="<?php echo e(asset('themes/adminmorelos/bower_components/jquery.sparkline/index.js')); ?>"></script>
	<script src="<?php echo e(asset('themes/adminmorelos/bower_components/chart.js/dist/Chart.min.js')); ?>"></script>
	<script src="<?php echo e(asset('themes/adminmorelos/bower_components/summernote/dist/summernote.min.js')); ?>"></script>
	<script src="<?php echo e(asset('themes/adminmorelos/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.js')); ?>"></script>
	<script src="<?php echo e(asset('themes/adminmorelos/dist/assets/js/forms/form-elements.js')); ?>"></script>

	<script src="<?php echo e(asset('themes/adminmorelos/dist/assets/js/app.min.js')); ?>"></script>

	<!--datatable-->
	<script src="<?php echo e(asset('themes/adminmorelos/dataTables/datatables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('themes/adminmorelos/dataTables/dataTables.bootstrap4.min.js')); ?>"></script>

    <script src="<?php echo e(asset('themes/adminmorelos/dist/assets/js/plugins/sweetalert/sweetalert.min.js')); ?>" defer></script>

	<script type="text/javascript" defer>
		var urlBase = "<?php echo url("/");?>";
		var dtEquipos = $('#tablaEquipos').DataTable( {
			bDestroy: true,
	        processing: true,
	        scrollY:    "350px",
	        pagingType: "simple_numbers",
	        scrollCollapse: true,
	        responsive: true,
	        dom: '<"html5buttons"B>lTfgitp',
	        ajax: urlBase+"/admin-morelos/equipos/lista",
	        buttons: [],
	        columns: [
	        	{
	        		"data": "logo",
	        		render: function(data) {
	                    if (data!=null) {
	                        label = urlBase+"/storage/equipos/"+data.logo;
	                    }else {
	                        label = urlBase+"/themes/deportivo/images/balon.png";
	                    }

	                    return '<img src="'+label+'" alt="" height="40px">';
	                }
	        	},
	            { "data": "nombre" },
	            { "data": "liga" },
	            { "data": "responsable" },
	        ]
	    });

	    $('#tablaEquipos tbody').on('click', 'tr', function () {
	        var data        = dtEquipos.row(this).selector.rows.attributes.id.value;
	        var idSelected  = data.split("row_")[1];
	        window.location = urlBase + "/admin-morelos/equipos/editar/"+idSelected;
	    });

	    $('#tablaJugadores').DataTable( {
			bDestroy: true,
	        processing: true,
	        scrollY:    "350px",
	        pagingType: "simple_numbers",
	        responsive: true,
	        dom: '<"html5buttons"B>lTfgitp',
	        ajax: urlBase+"/admin-morelos/jugadores/lista",
	        buttons: [],
	        columns: [
		        {
	                "data": {
	                    id: "id",
	                },
	                render: function(data) {
	                    html = '<div class="btn-group">';
	                        html += '<button data-toggle="dropdown" class="btn btn-warning btn-xs dropdown-toggle" aria-expanded="false">Acción</button>';
	                        html += '<ul class="dropdown-menu" x-placement="bottom-start">';
	                            html += '<li><a class="dropdown-item" onclick="multar('+data.id+')">Multar</a></li>';
	                        html += '</ul>'
	                    html += '</div>';
	                    return html;
	                }
	            },
	        	{
	        		"data": {
	        			id: 'id'
	        		},
	        		render: function(data) {
	                    label = urlBase+"/storage/jugadores/"+data.id+"/"+data.imagen;

	                    return '<img src="'+label+'" alt="" height="40px">';
	                }
	        	},
	            { "data": "nombres" },
	            { "data": "apellidos" },
	            { "data": "dni" },

                {
	                "data": {
	                    id: "id",
	                },
	                render: function(data) {
	                    return data.multas.length;
	                }
	            },
	        ]
	    });

	    function multar(idJugador){

	    	swal({
		        title: "Esta seguro que desea generar una multa al jugador?",
			  	text: "Ingrese las jornadas que no jugara",
			  	type: "input",
			  	showCancelButton: true,
			  	closeOnConfirm: false,
			  	animation: "slide-from-top",
			  	confirmButtonColor: "#ff0000",
		        confirmButtonText: "Multar",
		    }, function (inputValue) {
		    	if (inputValue === false) return false;

			  	if (inputValue === "") {
			    	swal.showInputError("Debe ingresar un valor");
			    	return false;
			  	}

			  	if (!Number.isInteger(parseInt(inputValue))) {
			  		swal.showInputError("Debe ingresar un valor numerico");
			    	return false;
			  	}

		        $.ajax({
		            type: "post",
		            url: urlBase+"/admin-morelos/jugadores/multar",
		            dataType: 'json',
		            data: {
		                _token: $('input[name=_token]').val(),
		                idJugador: idJugador,
		                cantidadJornadas: inputValue
		            },
		            beforeSend: function(b){
		                $("#confirmar").attr("disabled", true);
		            },
		            success: function (data){
		                if (!data.error) {
		                    swal("Finalizado!", data.mensaje, "success");
		                    window.location.reload(true);
		                }else{
		                    swal("Error!", data.mensaje, "error");
		                }
		            },
		            complete: function(c) {
		                $("#confirmar").attr("disabled", false);
		            },
		        });
		    });
	    }

	    function marcarCancelado(idJugador){
	    	swal({
		        title: "Esta seguro que desea cancelar el credencial?",
			  	text: "Ingrese el motivo de la cancelación",
			  	type: "input",
			  	showCancelButton: true,
			  	closeOnConfirm: false,
			  	animation: "slide-from-top",
			  	confirmButtonColor: "#ff0000",
		        confirmButtonText: "Multar",
		    }, function (inputValue) {
		    	if (inputValue === false) return false;

			  	if (inputValue === "") {
			    	swal.showInputError("Debe ingresar un valor");
			    	return false;
			  	}

		        $.ajax({
		            type: "post",
		            url: urlBase+"/admin-morelos/equipos/marcarCancelado",
		            dataType: 'json',
		            data: {
		                _token: $('input[name=_token]').val(),
		                idJugador: idJugador,
		                motivoCancelado: inputValue
		            },
		            beforeSend: function(b){
		                $("#confirmar").attr("disabled", true);
		            },
		            success: function (data){
		                if (!data.error) {
		                    swal("Finalizado!", data.mensaje, "success");
		                    window.location.reload(true);
		                }else{
		                    swal("Error!", data.mensaje, "error");
		                }
		            },
		            complete: function(c) {
		                $("#confirmar").attr("disabled", false);
		            },
		        });
		    });
	    }
	</script>
</body>
</html>
<?php /**PATH /Users/jayanowsky/Projects/php/deportivomorelos/resources/themes/adminmorelos/layouts/admin.blade.php ENDPATH**/ ?>