@extends('layouts.master')

@section("contenido")
    <div class="rs-breadcrumbs">
        <div class="breadcrumbs-wrap">
            <img src="{{ Theme::asset('images/breadcrumbs/bg1.jpg', null, false) }}" alt="Breadcrumbs Image">
            <div class="breadcrumbs-inner">
                <div class="container">
                    <div class="breadcrumbs-text">
                        <h1 class="breadcrumbs-title mb-17">Próximos Juegos</h1>
                        <div class="categories">
                            <ul>
                                <li><a href="{{ url('/') }}">Inicio</a></li>
                                <li class="active">Próximos Juegos</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>                
    </div>

    <div class="rs-match-fixture style2 pt-100 md-pt-80">
        <div class="container">
            <div class="match-list bg1 pt-57 pb-57 md-pt-27 md-pb-27 mb-100 md-mb-80">
                <table>
                    <tbody>
                        @if(count($proximosJuegos)>0)
                            @for($i= 0; $i < count($proximosJuegos); $i++)
                                @if( ( $i % 2 ) != 0 )
                                    <?php continue; ?>
                                @endif
                                <tr>
                                    <td class="medium-font">{{ $proximosJuegos[$i]->equipo }}</td>
                                    <td class="short-width">VS</td>
                                    <td class="medium-font">{{ $proximosJuegos[$i + 1]->equipo }}</td>
                                    <td>{{ $proximosJuegos[$i]->fecha }}, {{ $proximosJuegos[$i]->hora }}</td>
                                    <td>Cancha: {{ $proximosJuegos[$i]->cancha }}</td>
                                </tr>
                            @endfor
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection