<?php
use App\Equipo;

$equipos = Equipo::logosHome();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <!-- meta tag -->
    <meta charset="utf-8">
    <title>Club de Futbol | Deportivo Morelos</title>
    <meta name="description" content="">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="apple-touch-icon" href="apple-touch-icon.html">
    <link rel="shortcut icon" type="image/x-icon" href="">
    <link rel="stylesheet" type="text/css" href="{{ asset('themes/deportivo/css/bootstrap.min.css', null, false) }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('themes/deportivo/css/font-awesome.min.css', null, false) }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('themes/deportivo/css/owl.carousel.css', null, false) }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('themes/deportivo/css/animate.css', null, false) }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('themes/deportivo/css/slick.css', null, false) }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('themes/deportivo/css/off-canvas.css', null, false) }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('themes/deportivo/fonts/flaticon.css', null, false) }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('themes/deportivo/css/magnific-popup.css', null, false) }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('themes/deportivo/css/rsmenu-main.css', null, false) }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('themes/deportivo/css/swiper.min.css', null, false) }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('themes/deportivo/css/rsmenu-transitions.css', null, false) }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('themes/deportivo/css/rsanimations.css', null, false) }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('themes/deportivo/css/style.css?v=1.0', null, false) }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('themes/deportivo/css/rs-spaceing.css', null, false) }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('themes/deportivo/css/responsive.css', null, false) }}">

    <script src="{{ asset('themes/deportivo/js/jquery.min.js', null, false) }}" defer></script>
    <script src="{{ asset('themes/deportivo/js/modernizr-2.8.3.min.js', null, false) }}" defer></script>
    <script src="{{ asset('themes/deportivo/js/bootstrap.min.js', null, false) }}" defer></script>
    <script src="{{ asset('themes/deportivo/js/owl.carousel.min.js', null, false) }}" defer></script>
    <script src="{{ asset('themes/deportivo/js/slick.min.js', null, false) }}" defer></script>
    <script src="{{ asset('themes/deportivo/js/isotope.pkgd.min.js', null, false) }}" defer></script>
    <script src="{{ asset('themes/deportivo/js/imagesloaded.pkgd.min.js', null, false) }}" defer></script>
    <script src="{{ asset('themes/deportivo/js/wow.min.js', null, false) }}" defer></script>
    <script src="{{ asset('themes/deportivo/js/jquery.magnific-popup.min.js', null, false) }}" defer></script>
    <script src="{{ asset('themes/deportivo/js/rsmenu-main.js', null, false) }}" defer></script>
    <script src="{{ asset('themes/deportivo/js/plugins.js', null, false) }}" defer></script>
    <script src="{{ asset('themes/deportivo/js/jquery.counterup.min.js', null, false) }}" defer></script>
    <script src="{{ asset('themes/deportivo/js/waypoints.min.js', null, false) }}" defer></script>
    <script src="{{ asset('themes/deportivo/js/swiper.min.js', null, false) }}" defer></script>
    <script src="{{ asset('themes/deportivo/js/main.js', null, false) }}" defer></script>
</head>
<body>
    <div id="loading" class="loading">
        <div class="rs-loader">
            <div class="rs-shadow"></div>
            <div class="rs-gravity">
                <div class="rs-ball"></div>
            </div>
        </div>
    </div>

    <div class="full-width-header">
        <header id="rs-header" class="rs-header homestyle">
            <div class="menu-area menu-sticky">
                <div class="container-fluid">
                    <div class="row rs-vertical-middle">
                        <div class="col-lg-2">
                            <div class="logo-area">
                                <a href="{{ url('/') }}">
                                    <img src="{{ asset('themes/deportivo/images/logo-balco.png', null, false) }}" alt="logo">
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-10 mobile-menu-area">
                            <div class="rs-menu-area display-flex-center">
                                <div class="main-menu">
                                    <a class="rs-menu-toggle">
                                        <i class="fa fa-bars"></i>
                                    </a>
                                    <nav class="rs-menu">
                                        <div class="expand-btn">
                                            <span>
                                                <a id="nav-expander" class="nav-expander">
                                                    <ul class="offcanvas-icon">
                                                        <li>
                                                            <span class="hamburger1"></span>
                                                            <span class="hamburger2"></span>
                                                            <span class="hamburger3"></span>
                                                        </li>
                                                    </ul>
                                                </a>
                                            </span>
                                        </div>
                                        <?php
                                            $act = request()->path();
                                        ?>
                                        <ul class="nav-menu text-right">
                                            <li class="{{ ($act == '/') ? 'current-menu-item current_page_item' : '' }}">
                                                <a href="{{ url('/') }}" class="home">INICIO</a>
                                            </li>

                                            <li class="rs-mega-menu mega-rs menu-item-has-children {{ ($act == 'liga/sabatina') ? 'current-menu-item current_page_item' : '' }} {{ ($act == 'liga/dominical') ? 'current-menu-item current_page_item' : '' }}">
                                                <a href="#">LIGA</a>
                                                <ul class="mega-menu">
                                                    <li class="mega-menu-container">
                                                        <div class="mega-menu-innner">
                                                            <div class="single-megamenu">
                                                                <ul class="sub-menu">
                                                                    <li class="menu-title">
                                                                        SABATINA
                                                                    </li>
                                                                    <li>
                                                                        <a href="{{ url('/liga/sabatina/1') }}">
                                                                            Grupo 1
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a href="{{ url('/liga/sabatina/2') }}">
                                                                            Grupo 2
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a href="{{ url('/liga/sabatina/3') }}">
                                                                            Grupo 3
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a href="{{ url('/liga/sabatina/4') }}">
                                                                            M1
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a href="{{ url('/liga/sabatina/5') }}">
                                                                            M2
                                                                        </a>
                                                                    </li>
                                                                    <div class="sub-menu-close">
                                                                        <i class="fa fa-times" aria-hidden="true"></i>Close
                                                                    </div>
                                                                </ul>
                                                            </div>
                                                            <div class="single-megamenu">
                                                                <ul class="sub-menu md-pt-0">
                                                                    <li class="menu-title">
                                                                        DOMINICAL
                                                                    </li>
                                                                    <li>
                                                                        <a href="{{ url('/liga/dominical/1') }}">
                                                                            Grupo 1
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a href="{{ url('/liga/dominical/2') }}">
                                                                            Grupo 2
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a href="{{ url('/liga/dominical/3') }}">
                                                                            Grupo 3
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a href="{{ url('/liga/dominical/4') }}">
                                                                            Grupo 4
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a href="{{ url('/liga/dominical/5') }}">
                                                                            Grupo 5
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a href="{{ url('/liga/dominical/6') }}">
                                                                            Grupo 6
                                                                        </a>
                                                                    </li>
                                                                    <div class="sub-menu-close">
                                                                        <i class="fa fa-times" aria-hidden="true"></i>Close
                                                                    </div>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </li>
                                                    <div class="sub-menu-close">
                                                        <i class="fa fa-times" aria-hidden="true"></i>Close
                                                    </div>
                                                </ul>
                                                <span class="rs-menu-parent">
                                                    <i class="fa fa-angle-down" aria-hidden="true"></i>
                                                </span>
                                                <span class="rs-menu-parent">
                                                    <i class="fa fa-angle-down" aria-hidden="true"></i>
                                                </span>
                                            </li>

                                            <li class="menu-item-has-children {{ ($act == 'quienes-somos/institucion') ? 'current-menu-item current_page_item' : '' }} {{ ($act == 'quienes-somos/instalaciones') ? 'current-menu-item current_page_item' : '' }}">
                                                <a href="#">QUIENES SOMOS</a>
                                                <ul class="sub-menu">
                                                    <li>
                                                        <a href="{{ url('/quienes-somos/institucion') }}">
                                                            LA INSTITUCIÓN
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="{{ url('/quienes-somos/instalaciones') }}">
                                                            INSTALACIONES
                                                        </a>
                                                    </li>
                                                </ul>
                                            </li>

                                            <li class="{{ ($act == 'servicios') ? 'current-menu-item current_page_item' : '' }}">
                                                <a href="{{ url('/servicios') }}">SERVICIOS</a>
                                            </li>

                                            <li class="{{ ($act == 'noticias') ? 'current-menu-item current_page_item' : '' }}">
                                                <a href="{{ url('/noticias') }}">NOTICIAS</a>
                                            </li>

                                            <li class="{{ ($act == 'contacto') ? 'current-menu-item current_page_item' : '' }}">
                                                <a href="{{ url('/contacto') }}">CONTACTO</a>
                                            </li>
                                        </ul>
                                    </nav>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <nav class="right_menu_togle hidden-md">
                <div class="close-btn">
                    <span id="nav-close" class="text-center">
                        <i class="flaticon-cross"></i>
                    </span>
                </div>
                <div class="canvas-logo">
                    <a href="{{ url('/') }}">
                        <img src="{{ asset('themes/deportivo/images/logo.png', null, false) }}" alt="logo">
                    </a>
                </div>
                <div class="sidebarnav_menu">
                    <ul>
                        <li class="active">
                            <a href="{{ url('/') }}">INICIO</a>
                        </li>
                        <li>
                            <a href="{{ url('/quienes-somos/institucion') }}">LA INSTITUCIÓN</a>
                        </li>
                        <li>
                            <a href="{{ url('/quienes-somos/instalaciones') }}">INSTALACIONES</a>
                        </li>
                        <li>
                            <a href="{{ url('/servicios') }}">SERVICIOS</a>
                        </li>
                        <li>
                            <a href="{{ url('/noticias') }}">NOTICIAS</a>
                        </li>
                    </ul>
                </div>
                <div class="canvas-contact">
                    <h5 class="canvas-contact-title">CONTACTO</h5>
                    <ul class="contact">
                        <li>
                            <i class="fa fa-globe"></i>Av. Federalismo Norte #3281 Col. Atemajac. Guadalajara, Jalisco
                        </li>
                        <li>
                            <i class="fa fa-phone"></i>
                            <a href="tel:(33) 3660 5231">(33) 3660 5231</a>
                        </li>
                        <li>
                            <i class="fa fa-envelope"></i>
                            <a href="mailto:deportivomorelos@prodigy.net.mx">deportivomorelos@prodigy.net.mx</a>
                        </li>
                    </ul>
                    <ul class="social">
                        <li>
                            <a href="https://www.facebook.com/DeportivoMorelosMX/?__tn__=%2Cd%2CP-R&eid=ARBFHaaWxTSABhwdr8natG7o-vzJB1zpUdRGvg0cH8HsKemw2bMFnxU6lGvERaqysGiUdWUWEr17rlEJ" target="_blank">
                                <i class="fa fa-facebook"></i>
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>
    </div>

    @yield("contenido")

    <footer id="rs-footer" class="rs-footer dark-mode pt-137 md-pt-70 sm-pt-65">
        <!-- Sponsor Logo Section Start -->
        <div class="rs-sponsor normal-mood pb-125 md-pb-135 sm-pb-170">
            <div class="container">
                <div class="row">
                    <div class="col-lg-8 offset-lg-2 col-md-8 offset-md-2">
                        <div class="row">
                            @if (count($equipos)>0)
                                @foreach ($equipos as $eq)
                                    <div class="col-lg-3 col-md-4 col-6 mt-3">
                                        <div class="logos">
                                            <a href="#">
                                                @if ($eq->logo)
                                                    <img class="size-80" src="{{asset('storage/equipos/'.$eq->id.'/'.$eq->logo)}}">
                                                @else
                                                    <img class="size-80" src="{{asset('themes/deportivo/images/balon.png')}}">
                                                @endif
                                            </a>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Sponsor Logo Section End -->

        <!-- Footer Bottom Section Start -->
        <div class="footer-bootom">
            <div class="container">
                <div class="row rs-vertical-middle">
                    <div class="col-md-7">
                        <div class="copyright">
                            <p>© 2019 Deportivo Morelo. Todos los derechos reservados. Diseñado por <a href="https://braxishost.com" target="_blank">BraxisHost</a></p>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="footer-share text-right">
                            <ul>
                                <li>
                                    <a href="https://www.facebook.com/DeportivoMorelosMX/?__tn__=%2Cd%2CP-R&eid=ARBFHaaWxTSABhwdr8natG7o-vzJB1zpUdRGvg0cH8HsKemw2bMFnxU6lGvERaqysGiUdWUWEr17rlEJ" target="_blank">
                                        <i class="fa fa-facebook"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <div id="scrollUp">
        <i class="fa fa-angle-up"></i>
    </div>
</body>
</html>
