@extends('layouts.admin')
@section("content")
<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="card-block">
				<div class="row">
					<div class="col-md-6">
						<h4 class="card-title">Usuarios</h4>
					</div>
					<div class="col-md-6">
						<a href="{{url('admin-morelos/usuarios/crear')}}" class="btn btn-success pull-right">
							<i class="ti-plus pdd-right-5"></i>
							<span>Nuevo</span>
						</a>
					</div>
				</div>
				<div class="table-overflow">
					<table class="table">
						<thead>
							<tr>
								<th>Nombre</th>
								<th>E-Mail</th>
								<th>Rol</th>
								<th>Estado</th>
								<th>Acción</th>
							</tr>
						</thead>
						<tbody>
							@if(count($usuarios)>0)
								@foreach($usuarios as $u)
									<tr>
										<td>{{$u->nombre}}</td>
										<td>{{$u->email}}</td>
										<td>{{$u->rol}}</td>
										<td>
											<span class="{{$u->estado=='Activo'? 'text-success' : 'text-danger'}}">
												{{$u->estado}}
											</span>
										</td>
										<td>
											<div class="btn-group">
												<a href="{{url('admin-morelos/usuarios/editar')}}/{{$u->id}}" class="btn btn-info">
													<i class="ti-pencil"></i>
												</a>
												<a href="#" class="btn btn-danger"  onclick="$('#formDelete{{$u->id}}').submit()">
													<i class="ti-trash"></i>
												</a>
											</div>
											{!! Form::open(['method' => 'PUT', 'id' => "formDelete$u->id", 'onsubmit' => "return confirm('".trans("Esta Seguro de Eliminar?")."');", 'url' => "admin-morelos/usuarios/eliminar/$u->id"]) !!}
											{!! Form::close() !!}

										</td>
									</tr>
								@endforeach
							@else
								<tr>
									<td colspan="5">
										No hay registros
									</td>
								</tr>
							@endif
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection