@extends('layouts.admin')
@section("content")
<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="card-block">
				<div class="row">
					<div class="col-md-12">
						<h4 class="card-title">Usuarios</h4>
					</div>
				</div>
				@include('messages.messages')
				<div class="row">
					<div class="col-md-12">
						{!! Form::open(['url' => 'admin-morelos/usuarios/guardar', 'method' => 'post', 'class'=>'form-horizontal']) !!}
							<div class="row">
								<div class="col-md-6">
									<div class="form-group row">
										<label class="col-md-12 control-label">
											Nombre
										</label>
										<div class="col-md-12">
											{{Form::text('nombre', NULL, ["class"=>"form-control", "required"])}}
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group row">
										<label class="col-md-12 control-label">
											Rol
										</label>
										<div class="col-md-12">
											{{Form::select('rol', ['Administrador' => 'Administrador', 'Delegado' => 'Delegado'], NULL, ["required", "class"=>"form-control"])}}
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group row">
										<label class="col-md-12 control-label">
											E-mail
										</label>
										<div class="col-md-12">
											{{Form::email('email', NULL, ["class"=>"form-control", "required"])}}
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group row">
										<label class="col-md-12 control-label">
											Clave
										</label>
										<div class="col-md-12">
											{{Form::password('password', ["class"=>"form-control", "required"])}}
										</div>
									</div>
								</div>
								<div class="col-md-12">
									<button type="submit" class="btn btn-success">
										<i class="ti-save pdd-right-5"></i>
										<span>Guardar</span>
									</button>
								</div>
							</div>
						{!! Form::close() !!}
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection