@extends('layouts.admin')
@section("content")
<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="card-block">
				<div class="row">
					<div class="col-md-6">
						<h4 class="card-title">Noticias</h4>
					</div>
					<div class="col-md-6">
						<a href="{{url('admin-morelos/noticias/crear')}}" class="btn btn-success pull-right">
							<i class="ti-plus pdd-right-5"></i>
							<span>Nueva</span>
						</a>
					</div>
				</div>
				<div class="table-overflow">
					<table class="table">
						<thead>
							<tr>
								<th>Imagen</th>
								<th>Titulo</th>
								<th>Slug</th>
								<th>Acción</th>
							</tr>
						</thead>
						<tbody>
							@if(count($noticias)>0)
								@foreach($noticias as $n)
									<tr>
										<td>
											<img src="{{asset('storage/noticias/'.$n->id.'/'.$n->imagen)}}" height="40px">
										</td>
										<td>{{$n->titulo}}</td>
										<td>{{$n->slug}}</td>
										<td>
											<div class="btn-group">
												<a href="{{url('admin-morelos/noticias/editar')}}/{{$n->id}}" class="btn btn-info">
													<i class="ti-pencil"></i>
												</a>
											
												<a href="#" class="btn btn-danger"  onclick="$('#formDelete{{$n->id}}').submit()">
													<i class="ti-trash"></i>
												</a>
											</div>
											{!! Form::open(['method' => 'PUT', 'id' => "formDelete$n->id", 'onsubmit' => "return confirm('".trans("Esta Seguro de Eliminar?")."');", 'url' => "admin-morelos/noticias/eliminar/$n->id"]) !!}
											{!! Form::close() !!}
										</td>
									</tr>
								@endforeach
							@else
								<tr>
									<td colspan="4">No hay registros</td>
								</tr>
							@endif
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection
