@extends('layouts.admin')
@section("content")
<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="card-block">
				<div class="row">
					<div class="col-md-6">
						<h4 class="card-title">Credenciales por imprimir</h4>
					</div>
				</div>
				@include("messages.messages")
				<div class="table-overflow">
					<table class="table">
						<thead>
							<tr>
								<th>Imagen</th>
								<th>Nombres</th>
								<th>Apellidos</th>
								<th>Identificación</th>
								<th>Acción</th>
							</tr>
						</thead>
						<tbody>
							@if(count($jugadores)>0)
								@foreach($jugadores as $e)
									<tr>
										<td>
											<img src="{{asset('storage/jugadores/'.$e->id.'/'.$e->imagen)}}" height="40px">
										</td>
										<td>{{$e->nombres}}</td>
										<td>{{$e->apellidos}}</td>
										<td>{{$e->dni}}</td>
										<td>
											<div class="btn-group">
												<a target="_blank" href="{{url('admin-morelos/equipos/generateC')}}/{{$e->id}}" class="btn btn-success">
													<i class="ti-printer"></i> ({{ $e->impresiones }})
												</a>
												<a href="{{url('admin-morelos/equipos/marcar')}}/{{$e->id}}" class="btn btn-info">
													<i class="ti-check"></i>
												</a>
												<a onclick="marcarCancelado({{$e->id}})" href="#" class="btn btn-danger" title="Cancelar Impresión">
													<i class="ti-na"></i>
												</a>
											</div>
										</td>
									</tr>
								@endforeach
							@else
								<tr>
									<td colspan="5">No hay registros</td>
								</tr>
							@endif
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection