<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateJuegosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('juegos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('equipo');
            $table->integer('liga');
            $table->integer('resultado');
            $table->unsignedBigInteger('idApi');
            $table->unsignedBigInteger('estado')->default(1);
            $table->date('fecha');
            $table->time('hora');
            $table->enum('cancha', ['1','2','3','4','5','6']);
            $table->enum('grupo', ['1','2','3','4','5','6']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('juegos');
    }
}
