<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Juego extends Model
{
    protected $fillable = ['equipo','cancha','fecha','liga','grupo','hora','resultado', 'idApi'];

    public static function cargaApi($id, $data)
    {
    	return static::updateOrCreate(['idApi'=> $id], $data);
    }

    public static function jornadasSabatinas($grupo)
    {
        return static::select("fecha")
            ->where("grupo", "=", $grupo)
            ->where("liga", "=", 1)
            ->groupBy("fecha")
            ->orderBy("fecha", "ASC")
            ->get();
    }

    public static function jornadasDominical($grupo)
    {
        return static::select("fecha")
            ->where("grupo", "=", $grupo)
            ->where("liga", "=", 2)
            ->groupBy("fecha")
            ->orderBy("fecha", "ASC")
            ->get();
    }

    public static function juegosSabatinos($grupo, $jornada)
    {
        return static::select("juegos.*", "equipos.nombre")
            ->join("equipos", "equipos.idApi", "=", "juegos.equipo")
            ->where("juegos.grupo", "=", $grupo)
            ->where("juegos.fecha", "=", $jornada)
            ->where("juegos.liga", "=", 1)
            ->orderBy("juegos.cancha", "ASC")
            ->get();
    }

    public static function juegosDominical($grupo, $jornada)
    {
        return static::select("juegos.*", "equipos.nombre")
            ->join("equipos", "equipos.idApi", "=", "juegos.equipo")
            ->where("juegos.grupo", "=", $grupo)
            ->where("juegos.fecha", "=", $jornada)
            ->where("juegos.liga", "=", 2)
            ->orderBy("juegos.cancha", "ASC")
            ->get();
    }

    public static function traerTodos()
    {
    	return static::orderBy("fecha", "ASC")->get();
    }

    public static function proximoJuego()
    {
    	return static::select("juegos.fecha", "juegos.hora", "juegos.grupo", "juegos.grupo", "juegos.cancha", \DB::raw("equipos.nombre as equipo"), \DB::raw("equipos.logo as logotipo"))
    		->join("equipos", "equipos.idApi", "=", "juegos.equipo")
    		->where("juegos.fecha", ">=", date("Y-m-d"))
    		->where("juegos.hora", ">=", date("H:i"))
    		->orderBy("juegos.fecha", "ASC")
    		->orderBy("juegos.hora", "ASC")
    		->orderBy("juegos.grupo", "ASC")
    		->orderBy("juegos.cancha", "ASC")
    		->limit(2)
    		->get();
    }

    public static function proximosJuegos()
    {
    	return static::select("juegos.fecha", "juegos.hora", "juegos.grupo", "juegos.grupo", "juegos.cancha", \DB::raw("equipos.nombre as equipo"), \DB::raw("equipos.logo as logotipo"))
    		->join("equipos", "equipos.idApi", "=", "juegos.equipo")
    		->where("juegos.fecha", ">", date("Y-m-d"))
    		->orderBy("juegos.fecha", "DESC")
    		->orderBy("juegos.hora", "DESC")
    		->orderBy("juegos.grupo", "DESC")
    		->orderBy("juegos.cancha", "DESC")
    		->limit(12)
    		->get();
    }

    public static function juegosAnteriores()
    {
    	return static::select("juegos.fecha", "juegos.hora", "juegos.resultado", "juegos.grupo", "juegos.grupo", "juegos.cancha", \DB::raw("equipos.nombre as equipo"), \DB::raw("equipos.logo as logotipo"))
    		->join("equipos", "equipos.idApi", "=", "juegos.equipo")
    		->where("juegos.fecha", "<", date("Y-m-d"))
            ->where("juegos.resultado", ">=", 0)
            ->where("equipos.nombre", "!=", "Bye")
    		->orderBy("juegos.fecha", "DESC")
    		->orderBy("juegos.hora", "DESC")
    		->orderBy("juegos.grupo", "DESC")
    		->orderBy("juegos.cancha", "DESC")
    		->limit(12)
    		->get();
    }
}
