<?php

namespace App\Http\Controllers\front;

use Theme;
use App\Juego;
use App\Noticia;
use App\Posicion;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class HomeController extends Controller
{
	public function __construct()
    {
    	Theme::init("deportivo");
    }

    public function index()
    {
    	$proximoJuego     = Juego::proximoJuego();
    	$proximosJuegos   = Juego::proximosJuegos();
    	$juegosAnteriores = Juego::juegosAnteriores();
        $noticias         = Noticia::noticiasHome();

        return View("front.index")->with(compact("proximoJuego", "proximosJuegos", "juegosAnteriores", "noticias"));
    }
}
