<?php

namespace App\Http\Controllers\Admin;

use DB;
use Theme;
use App\User;
use App\Juego;
use App\Multa;
use App\Equipo;
use App\Jugador;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class JugadorController extends Controller
{
	public function __construct()
    {
    	Theme::init("adminmorelos");
    }

    public function index()
    {
    	$equipoID = null;
        $searchEquipoID = DB::table('equipos')
            ->select('*')
            ->where('id_usuario','=', Auth()->user()->id)
            ->get();

        foreach ($searchEquipoID as $equipo) {
            $equipoID = $equipo->id;
        }

        $jugadores = DB::table('jugadores as a')
         	->select('a.id','a.nombres','a.apellidos','a.dni','a.imagen','a.created_at', 'a.estado', 'a.motivoCancelado')
         	->where('a.id_equipo','=', $equipoID)
         	->orderby('created_at','ASC')
         	->get();
        return view('delegados/jugadores/lista')->with(compact("jugadores"));
    }

    public function lista()
	{

		$respuesta = ["data"=>false];
		$jugadores = Jugador::with('equipo', 'multas')->get()->toJson();

    	if ($jugadores) {
            $respuesta["data"] = json_decode($jugadores);
        }

		return $respuesta;
	}

    public function crear()
    {
        return view('delegados/jugadores/crear');
    }

    public function guardar(Request $request)
	{
        $searchEquipoID = DB::table('equipos')
            ->select('*')
            ->where('id_usuario','=', Auth()->user()->id)
            ->get();

        foreach ($searchEquipoID as $equipo) {
            $equipoID = $equipo->id;
        }

		$jugadores=new Jugador;
		$imagen=$request->file('imagen');
		$nombre_imagen=$imagen->getClientOriginalName();
		$jugadores->nombres=$request->nombres;
		$jugadores->apellidos=$request->apellidos;
		$jugadores->dni=$request->dni;
		$jugadores->id_equipo= $equipoID;
		$jugadores->imagen=$nombre_imagen;
		\DB::beginTransaction();
		try {
			if ($jugadores->save()) {
				\Storage::disk('public')->put('jugadores/'.$jugadores->id."/".$nombre_imagen,  \File::get($imagen));
			}
			\DB::commit();
			return redirect()->back()->with("success", "Datos Guardados");
		} catch (\Illuminate\Database\QueryException $e) {
			\DB::rollback();
			if($e->getCode()==23000){
				return redirect()->back()->withInput()->with("error", "Jugador duplicado");
			}else{
				return redirect()->back()->withInput()->with("error", "Ocurrio un error, intenta de nuevo, si el problema persiste contacta con el proveedor");
			}
		}
	}

	public function editar($id)
	{
		$jugadores = Jugador::findOrFail($id);
		$imagen = DB::table('jugadores')
            ->select('imagen','id')
            ->where('id','=',$id)
            ->get();
		return view('delegados/jugadores/editar')->with(compact('jugadores','imagen'));
	}

	public function actualizar(Request $request,$id)
	{
        $searchEquipoID = DB::table('equipos')
            ->select('*')
            ->where('id_usuario','=', Auth()->user()->id)
            ->get();

        foreach ($searchEquipoID as $equipo) {
            $equipoID = $equipo->id;
        }

		if(! is_null($request->imagen)) {
			$jugadores = Jugador::findOrFail($id);
			$imagen=$request->file('imagen');
			$nombre_imagen=$imagen->getClientOriginalName();
			$jugadores->nombres=$request->nombres;
			$jugadores->apellidos=$request->apellidos;
			$jugadores->dni=$request->dni;
			$jugadores->id_equipo= $equipoID;
			$jugadores->imagen=$nombre_imagen;
			\DB::beginTransaction();
			try {
				if ($jugadores->update()) {
					\Storage::disk('public')->put('jugadores/'.$jugadores->id."/".$nombre_imagen,  \File::get($imagen));
				}
				\DB::commit();
				return redirect()->back()->with("success", "Datos Modificados");
			} catch (\Illuminate\Database\QueryException $e) {
				\DB::rollback();
				if($e->getCode()==23000){
					return redirect()->back()->withInput()->with("error", "Equipo duplicado");
				}else{
					return redirect()->back()->withInput()->with("error", "Ocurrio un error, intenta de nuevo, si el problema persiste contacta con el proveedor");
				}
			} catch (\Exception $ex){
				\DB::rollback();
				return redirect()->back()->withInput()->with("error", "Error al cargar imagen");
			}
		} else {
			$jugadores = Jugador::findOrFail($id);
			$jugadores->nombres=$request->nombres;
			$jugadores->apellidos=$request->apellidos;
			$jugadores->dni=$request->dni;
			$jugadores->id_equipo= $equipoID;
			$jugadores->update();
			return redirect()->back()->with("success", "Datos Modificados");
		}
	}

	public function solicitar($id)
	{
		$jugadores         = Jugador::findOrFail($id);
		$jugadores->estado = 1;
		$jugadores->update();
		return redirect()->back()->with("success", "Se ha solicitado correctamente el credencial");
	}


	public function borrar($id)
	{
		$jugador = Jugador::findOrFail($id);
        $imagen = DB::table('jugadores')
            ->select('imagen','id')
            ->where('id','=',$id)
            ->get();

		return view('delegados/jugadores/borrar')->with(compact('jugador','imagen'));
	}

	public function eliminar($id)
	{
		$jugador = Jugador::findOrFail($id);
		$jugador->delete();
	    return redirect()->to('admin-morelos/jugadores');
	}

	public function multar(Request $request)
	{
		$jugador = Jugador::findOrFail($request->idJugador);
		$juegos  = Juego::select("fecha")->where("fecha", ">", date("Y-m-d"))->where("equipo", "=", $jugador->id_equipo)->groupBy("fecha")->orderby("fecha", "ASC")->get();
        $cantidadJornadasMulta = $request->cantidadJornadas;

		if ( count($juegos) > 0 ) {

			for ($i=0; $i < $cantidadJornadasMulta; $i++) {
                if( isset($juegos[$i]) ){
                    $multa = new Multa;
                    $multa->idJugador = $request->idJugador;
                    $multa->idEquipo  = $jugador->id_equipo;
                    $multa->fecha     = $juegos[$i]->fecha;
                    $multa->save();
                }
			}

		}

		return ["error"=>false, "mensaje"=>"Multa creada correctamente"];
	}
}
